#!/usr/bin/python3
"""Upotreba ./validate.py test/*.in*"""

import string

s = []
puzzle = []
p = []
n = 0
m = 0
k = 0
imam = [0 for i in range(50*50*3)]
boja = 0
bio = [[0] * 50 in range(50)]
sve_rupe_kvad = 1

smjerx = [0, 0, 1, -1]
smjery = [-1, 1, 0, 1]

def check_kvad(p):
	suma = 0
	for i in range(5):
		for j in range(5):
			if p[i][j] == '1':
				suma += 1
	for sz in range(1, 6):
		for i in range(5):
			for j in range(5):
				tmp = 0
				for i1 in range(sz):
					for j1 in range(sz):
						if i + i1 > 4 or j + j1 > 4 or p[i + i1][j + j1] == '0': tmp = 1000
						else: tmp += 1

				if tmp == suma:
					return 1
	return 0

def check_prav(p):
	suma = 0
	for i in range(5):
		for j in range(5):
			if p[i][j] == '1':
				suma += 1
	for sz in range(1, 6):
		for sz1 in range(1, 6):
			for i in range(5):
				for j in range(5):
					tmp = 0
					for i1 in range(sz):
						for j1 in range(sz1):
							if i + i1 > 4 or j + j1 > 4 or p[i + i1][j + j1] == '0': tmp = 1000
							else: tmp += 1
	
					if tmp == suma:
						return 1
	return 0

def dfs(x, y):
	global bio, imam, smjerx, smjery, boja, s
	bio[x][y] = boja
	imam[boja] += 1

	for i in range(4):
		nx = x + smjerx[i]
		ny = y + smjery[i]
		if nx < 0 or ny < 0 or nx >= n or ny >= m or bio[nx][ny] or s[nx][ny] == '1': continue
		dfs(nx, ny)

def check(lines):
	print ("Provjeri jedinstvenost rjesenja s rjesenje kodom")
	global imam, oznake, bio, boja, p, n, m, k, s
	nl = []   # ispravno formatirane linije

	n, m = map(int, lines[0].strip().split())
	assert 3 <= n <= 50, "n kriv"
	assert 3 <= m <= 50, "m kriv"
	nl.append("{} {}\n".format(n, m))

	s = []
	for i in range(n):
		si = lines[1 + i].strip()
		assert len(si) == m, "duljina linije u matrici != m"
		s.append(si)
		nl.append("{}\n".format(si))

	imam = [0 for i in range(50*50*3)]
	oznaka = [0 for i in range(50*50*3)]
	bio = [[0 for j in range(55)] for i in range(55)]
	boja = 0
	sve_rupe_kvad = 1
	
	for i in range(n):
		for j in range(m):
			if bio[i][j] > 0 or s[i][j] == '1': continue
			boja += 1
			dfs(i, j)

	for sz in range(1, min(n, m) + 1):
		for i in range(n):
			for j in range(m):
				boje = []
				krivo = 0
				for i1 in range(sz):
					for j1 in range(sz):
						if i + i1 >= n or j + j1 >= m or s[i + i1][j + j1] == '1': krivo = 1
						else:
							if bio[i + i1][j + j1] not in boje:
								boje.append(bio[i + i1][j + j1])

				if not krivo and len(boje) == 1 and sz * sz == imam[boje[0]]:
					oznaka[boje[0]] = 1

	for i in range(50 * 50 * 3):
		if imam[i] and not oznaka[i]: sve_rupe_kvad = 0
	
	k = int(lines[1 + n].strip())
	assert 1 <= k <= 30, "k kriv"
	nl.append("{}\n".format(k))

	sve_puz_kvad = 1
	sve_puz_prav = 1

	for i in range(k):
		p = []
		for j in range(5):
			si = lines[1 + n + 1 + i * 5 + j].strip()
			assert len(si) == 5, "sirina puzle != 5"
			p.append(si)
			nl.append("{}\n".format(si))
		assert len(p) == 5, "duzina puzle != 5"

		sve_puz_kvad *= check_kvad(p)
		sve_puz_prav *= check_prav(p)

	assert lines == nl, "Krivi format (%s vs %s)" % (lines, nl)
	assert lines[-1][-1] == "\n", "Zadnji red ne zavrsava sa \\n"
	return n, m, sve_rupe_kvad, sve_puz_kvad, sve_puz_prav

# Ocekivani clusteri! Ovo vjerojatno zelis promijeniti!
expected_clusters = {'normalno': 3, 'sve_rupe_kvad' : 3, 'sve_puz_prav' : 4}

def what_cluster(data):
	n, m, a, b, c = data
	if a and b: return 'sve_rupe_kvad'
	if c: return 'sve_puz_prav'
	return 'normalno'

################### Zadatak-specifican kod iznad ove linije #########################

import sys
import glob
import hashlib


def group_in_batches(files):
	# mnozenje.in.1a, mnozenje.in.1b sprema u isti batch

	files.sort()
	B = []
	for f in files:
		if f[-1].islower() and len(B) > 0 and f[:-1] == B[-1][-1][:-1]:
			B[-1].append(f)
		else:
			B.append([f])
	return B


if __name__ == "__main__":
	f = []
	for pattern in sys.argv[1:]:
		for filename in glob.glob(pattern):
			f.append(filename)

	bc = []
	for batch in group_in_batches(f):
		if 'dummy' not in batch[0]:
			bc.append([])
			for filename in batch:
				print("{}: ".format(filename), end="")
				try:
					lines = open(filename).readlines()
					summary = check(lines)
					c = what_cluster(summary)
					if 'dummy' not in batch[0]:
						bc[-1].append(c)
				except Exception as e:
					print("Greska!", e)
					raise
				else:
					print("Sve ok! (cluster {}, summary = {})".format(c, summary))
	clusters = {}
	for b in bc:
		for c in b:
			assert c == b[0], "Ima razlicitih cluster-a unutar batcha"
		if not b[0] in clusters:
			clusters[b[0]] = 0
		clusters[b[0]] += 1

	assert clusters == expected_clusters, "Kriva raspodjela clustera ({} vs {})".format(clusters, expected_clusters)

	# Buda test - provjeri duplikate
	hashes = set(hashlib.sha1(open(x, 'rb').read()).hexdigest() for x in f)
	assert len(hashes) == len(f), "Ima duplikata!"
